

function save(data,filename){
	fulldata="<html>\n";
	fulldata+="<head><style>\n"
	fulldata+="body{font-family: tahoma;}\n";
	fulldata+="h1{text-align:center;}\n";
	fulldata+="#scorecard{margin-left:auto;margin-right:auto;border-collapse: collapse;clear:both;}\n";
	fulldata+="#scorecard td{padding:10px;}\n";
	fulldata+=".jname{text-align:center;border-bottom:1px solid black;}\n";
	fulldata+=".score{text-align:center;border-bottom:1px dotted black;border-right:1px dotted black;}\n";
	fulldata+=".cname{text-align:right;border-right:1px solid black;}\n";
	fulldata+="#finalscore{font-size:2em;}\n";
	fulldata+="#results{text-align:center;}\n";
	fulldata+="#medalcalc{margin-left:auto;margin-right:auto;}\n";
	fulldata+="#judgesummary{border-right:1px solid black;padding: 20px;vertical-align:top;}\n";
	fulldata+="#medalsummary{padding: 20px;vertical-align:top;}\n";
	fulldata+="</style></head>\n";
	fulldata+='<body><h1>Competition Results</h1>\n';
	fulldata+='<div id="results">\n';
	fulldata+=data;
	fulldata+="</div></body></html>\n";
	
	let blob=new Blob([fulldata],{type: "text/plain;charset=utf-8"});
 	if(window.navigator.msSaveorOpenBlob){
		console.log("MS");
		window.navigator.msSaveBlob(file,filename);
	}
 	else{
		console.log("Other");
		const elem = window.document.createElement('a');
		elem.href= window.URL.createObjectURL(blob);
		elem.download= filename;
		document.body.appendChild(elem);
		elem.click();
		document.body.removeChild(elem);
		URL.revokeObjectURL(blob);
	}
}

function calcwinner(comps,judges){
	debug="";

	allowmultisecond=document.getElementById("multi2").value=="true";
	allowmultithird=document.getElementById("multi3").value=="true";

//	if(allowmultisecond) debug+="Allowing multi 2nds<br/>";
//	if(allowmultithird) debug+="Allowing multi 3rds<br/>";	
	
	var competitors=[]
	scorecard='<table id="scorecard"><tr id="scoreheadings"><td></td>';
	for(j=0;j<judges;j++){
		scorecard +='<td class="jname">'+document.getElementById("jname"+j).value+'</td>';
	}
	scorecard +='<td class="jname">Public</td>';
	scorecard +='</tr>';
	for(c=0;c<comps;c++){
		
		scorecard +='<tr>';
 		var comp={name:document.getElementById("cname"+c).value,g:0,s:0,b:0,p:0};
		competitors.push(comp);
		scorecard +='<td class="cname">'+comp.name+'</td>';
		for(j=0;j<judges;j++){
			scorecard +='<td class="score">'+document.getElementById("sc"+c+''+j).value+'</td>';
		}
		scorecard +='<td class="score">'+document.getElementById("scp"+c).value+'</td></tr>';
	}

	scorecard +='</table>';
	results='<table id="medalcalc"><tr><td id="judgesummary">';
	for(j=0;j<judges;j++){
       var g=-1;
		var s=-1;
		var b=-1;
		var gs=-1;
		var ss=-1;
		var bs=-1;
		var rejected=-1
		judge=document.getElementById("jname"+j).value;
     	for(c=0;c<comps;c++){
			if (isNaN(document.getElementById("sc"+c+""+j).value)){
				alert("All scores must be numerical!");
				return;
			}
 			score=parseInt(document.getElementById("sc"+c+""+j).value);
			if (score>=gs){//new gold, push everything down
				b=s;bs=ss;
				s=g;ss=gs;
				g=c;
				gs=score;
			}else if(score>=ss){//new silver, push silver down
				b=s;bs=ss;
				s=c;ss=score;
			}else if(score>=bs){//new bronze
				rejected=bs;
				b=c;bs=score;
			}
		}
		//check for ambiguity
		if(gs==ss){
			alert(judge+ " has abiguity in their scores: no clear 1st place");
			return;
		}
		if(ss==bs){
			alert(judge+ " has abiguity in their scores: no clear 2nd place");
			return;

		}
		if(bs==rejected){
			alert(judge+ " has abiguity in their scores: no clear 3rd place");
			return;

		}

 		results+=judge+" gives<br/>";
		results+="Gold to "+competitors[g].name+" with "+gs+" points<br/>";
		results+="Silver to "+competitors[s].name+" with "+ss+" points<br/>";
		results+="Bronze to "+competitors[b].name+" with "+bs+" points<br/><br/>"
		competitors[g].g++;
		competitors[s].s++;
		competitors[b].b++;
	}
	results+='</td><td id="medalsummary">';
	for(c=0;c<comps;c++){
		if (isNaN(document.getElementById("scp"+c).value)){
			alert("all scores must be numerical!");
			return;
		}
		competitors[c].p=parseInt(document.getElementById("scp"+c).value);
		results+=competitors[c].name+ " has<br/>";
		results+=competitors[c].g+" G, ";
		results+=competitors[c].s+" S, ";
		results+=competitors[c].b+" B, ";
		results+=competitors[c].p+" P<br/><br/>";
	}
	results+="</td></tr></table>";

	//1st place calc
	// most gold wins, 
	// if tied for gold most silver wins,
	// if tied for silver most bronze wins
	// if tied for bronze most popular wins
	// to achieve this we apply ridiculous multipliers
	var first=-1;
	var top=-1;
	var alsorans=[];
	for(c=0;c<comps;c++){
		total=competitors[c].g*1000000+competitors[c].s*1000+competitors[c].b
		if (total>top){
			top=total;
			first=c;
			alsorans=[];//new clear winner, ditch the alsorans
		}else if(total==top){ //it came down to plastic medals!
			if (competitors[c].p>competitors[first].p){
				first=c;
				alsorans=[];//new clear winner, ditch the alsorans
			} else if (competitors[c].p==competitors[first].p){
				alsorans.push(c);//oh no, people have identical scores
			}
		}
	}

	// there can be no joint 1st
	if (alsorans.length>0){
		message="Uh oh! ";
		for(i=0;i<alsorans.length;i++){
			message+=competitors[alsorans[i]].name+", ";
		}
		message+="and "+competitors[first].name;
		message+=" are exactly tied for first place! ";
		message+="Ask everyone to submit an additional public vote and run the scoresheet again!";
		alert(message);
		return;
	}

	winners='<div id="finalscore">';
	winners+=competitors[first].name+ " is the winner!<br/>"
	// there can be no joint 1st, but we will allow joint second and third.
	// 2nd place calc
	// leftover golds are converted to 2 silvers each.
	// most silver wins,
	// if tied for silver most bronze wins
	// if tied for bronze most popular wins
	//to achieve this we apply slightly less ridiculous multipliers
	var second=-1;
	top=-1;
	alsorans=[];
	for(c=0;c<comps;c++){
		if ( c==first){ 
			continue; // the winner can't come 2nd, that's just silly.
		}
		total=competitors[c].g*2000+competitors[c].s*1000+competitors[c].b
		if (total>top){
			top=total;
			second=c;
			alsorans=[];//new clear second, ditch the also rans
		}else if(total==top){ //it came down to plastic medals!
			if (competitors[c].p>competitors[second].p){
				second=c;
				alsorans=[];//new clear second, ditch the also rans
			} else if (competitors[c].p==competitors[second].p){
				alsorans.push(c);//oh no, people have identical scores
			}
		}
	}
	
	if (alsorans.length==0){//only one second place, so get third.
		winners+=competitors[second].name+ " comes 2nd.<br/>";
		var third=-1;
		top=-1;
		alsorans=[];
		for(c=0;c<comps;c++){
			if ( c==first || c==second){ 
				continue; // the winner and runner up can't come 3rd, that's just silly.
			}
			total=competitors[c].g*4+competitors[c].s*2+competitors[c].b
			if (total>top){
				top=total;
				third=c;
				alsorans=[];//new clear third, ditch the also rans
			}else if(total==top){ //it came down to plastic medals!
				if (competitors[c].p>competitors[third].p){
					thirs=c;
					alsorans=[];//new clear third, ditch the also rans
				} else if (competitors[c].p==competitors[third].p){
					alsorans.push(c); //oh no, people have identical scores 
				}
			}
		}
		if (alsorans.length==0){	
			winners+=competitors[third].name+ " comes 3rd.";
		}else{
			if(!allowmultithird){//if we don't allow multi-thirds we need to get more votes.
 				message="Uh oh! ";
				for(i=0;i<alsorans.length;i++){
					message+=competitors[alsorans[i]].name+", ";
				}
				message+="and "+competitors[third].name;
				message+=" are exactly tied for third place! ";
				message+="Ask everyone to submit an additional public vote and run the scoresheet again!";
				alert(message);
				return;
			}
			for(i=0;i<alsorans.length;i++){
				results+=competitors[alsorans[i]].name+", ";
			}
			winners +="and "+competitors[third].name+" are tied for 3rd place.";
		}
	}else{// multiple seconds, don't bother with 3rd.
		if(!allowmultisecond){//if we don't allow multi-seconds we need to get more votes.
 			message="Uh oh! ";
			for(i=0;i<alsorans.length;i++){
				message+=competitors[alsorans[i]].name+", ";
			}
			message+="and "+competitors[second].name;
			message+=" are exactly tied for secodnd place! ";
			message+="Ask everyone to submit an additional public vote and run the scoresheet again!";
			alert(message);
			return;
		}
		for(i=0;i<alsorans.length;i++){
			results+=competitors[alsorans[i]].name+", ";
		}
		winners +="and "+competitors[second].name+" are tied for 2nd place.";
	}
	
	winners+="</div>";
	
	var resultspage=document.getElementById("results");
	resultspage.innerHTML=debug+winners+scorecard+results;
	resultspage.style.display="block";
	predecessor=document.getElementById("scoresheet");
	predecessor.style.display="none";
	fulldata=winners+scorecard+results;
	save(fulldata, "scorecard.html");
}

function scorefill(comps,judges){
	for(c=0;c<comps;c++){
		for(j=0;j<judges;j++){
			document.getElementById("sc"+c+""+j).value=""+Math.floor(Math.random() * 300);
		}
		document.getElementById("scp"+c).value=""+Math.floor(Math.random() * 300);
	}
}

function initialiseform(){
	var comps=document.getElementById("numcomps").value;
	var judges=document.getElementById("numjudge").value;
	
	if (isNaN(comps)){
		alert("Competitors is not a number.");
		return;
	}
	if (isNaN(judges)){
		alert("Judges is not a number.");
		return;
	}
	if (comps<=0){
		alert("Need at least one competitor");
		return;
	}
	if (judges<=0){
		alert("Need at least one judge");
		return;
	}

	var sheet='<form><table>';
		sheet+='<tr><td>Competitors</td>';
		for (var j=0;j<judges;j++){
			sheet+='<td><input id="jname'+j+'" value="judge '+(j+1)+'"/></td>';
		}

		sheet+='<td>Popular vote</td>';
		sheet+='</tr>';
	for (var i=0;i<comps;i++){
		sheet+='<tr><td><input id="cname'+i+'" value="Competitor '+(i+1)+'"/></td>';
		for (var j=0;j<judges;j++){

			sheet+='<td><input id="sc'+i+''+j+'" value="score"/></td>';
			
		}
		sheet+='<td><input id="scp'+i+'" value="0"/></td>';
		sheet+='</tr>';
	}
	sheet+='</table>'
	sheet+='<input type="hidden" id="multi2" value="'+document.getElementById("multi2nd").checked+'"></input>';
	sheet+='<input type="hidden" id="multi3" value="'+document.getElementById("multi3rd").checked+'"></input>';
	sheet+='<button onClick="calcwinner('+comps+','+judges+');" type="button">Calculate Winner</button>';
	if (document.getElementById("autofill").checked)
		sheet+='<button onClick="scorefill('+comps+','+judges+');"  id="testfill" type="button">Random Fill</button>';	
		sheet+='</form>';
	
	var scoresheet=document.getElementById("scoresheet");
	scoresheet.innerHTML=sheet;
	scoresheet.style.display="block";

	predecessor=document.getElementById("initialisor");
	predecessor.style.display="none";
}
